"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var n=require("three"),e=require("../helpers/constants.cjs.js");function t(n){if(n&&n.__esModule)return n;var e=Object.create(null);return n&&Object.keys(n).forEach((function(t){if("default"!==t){var o=Object.getOwnPropertyDescriptor(n,t);Object.defineProperty(e,t,o.get?o:{enumerable:!0,get:function(){return n[t]}})}})),e.default=n,Object.freeze(e)}var o=t(n);class i extends o.ShaderMaterial{constructor(){super({uniforms:{depth:{value:null},opacity:{value:1},attenuation:{value:2.5},anglePower:{value:12},spotPosition:{value:new o.Vector3(0,0,0)},lightColor:{value:new o.Color("white")},cameraNear:{value:0},cameraFar:{value:1},resolution:{value:new o.Vector2(0,0)}},transparent:!0,depthWrite:!1,vertexShader:"\n      varying vec3 vNormal;\n      varying vec3 vWorldPosition;\n      varying float vViewZ;\n      varying float vIntensity;\n      uniform vec3 spotPosition;\n      uniform float attenuation;      \n\n      void main() {\n        // compute intensity\n        vNormal = normalize( normalMatrix * normal );\n        vec4 worldPosition\t= modelMatrix * vec4( position, 1.0 );\n        vWorldPosition = worldPosition.xyz;\n        vec4 viewPosition = viewMatrix * worldPosition;\n        vViewZ = viewPosition.z;\n        float intensity\t= distance(worldPosition.xyz, spotPosition) / attenuation;\n        intensity\t= 1.0 - clamp(intensity, 0.0, 1.0);\n        vIntensity = intensity;        \n        // set gl_Position\n        gl_Position\t= projectionMatrix * viewPosition;\n\n      }",fragmentShader:`\n      #include <packing>\n\n      varying vec3 vNormal;\n      varying vec3 vWorldPosition;\n      uniform vec3 lightColor;\n      uniform vec3 spotPosition;\n      uniform float attenuation;\n      uniform float anglePower;\n      uniform sampler2D depth;\n      uniform vec2 resolution;\n      uniform float cameraNear;\n      uniform float cameraFar;\n      varying float vViewZ;\n      varying float vIntensity;\n      uniform float opacity;\n\n      float readDepth( sampler2D depthSampler, vec2 coord ) {\n        float fragCoordZ = texture2D( depthSampler, coord ).x;\n        float viewZ = perspectiveDepthToViewZ(fragCoordZ, cameraNear, cameraFar);\n        return viewZ;\n      }\n\n      void main() {\n        float d = 1.0;\n        bool isSoft = resolution[0] > 0.0 && resolution[1] > 0.0;\n        if (isSoft) {\n          vec2 sUv = gl_FragCoord.xy / resolution;\n          d = readDepth(depth, sUv);\n        }\n        float intensity = vIntensity;\n        vec3 normal\t= vec3(vNormal.x, vNormal.y, abs(vNormal.z));\n        float angleIntensity\t= pow( dot(normal, vec3(0.0, 0.0, 1.0)), anglePower );\n        intensity\t*= angleIntensity;\n        // fades when z is close to sampled depth, meaning the cone is intersecting existing geometry\n        if (isSoft) {\n          intensity\t*= smoothstep(0., 1., vViewZ - d);\n        }\n        gl_FragColor = vec4(lightColor, intensity * opacity);\n\n        #include <tonemapping_fragment>\n\t      #include <${e.version>=154?"colorspace_fragment":"encodings_fragment"}>\n      }`})}}exports.SpotLightMaterial=i;
